/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;

public final class ResourceUtil {
    private static final Map<ResourceLocation, IMetadataSectionCTM> metadataCache = new HashMap<ResourceLocation, IMetadataSectionCTM>();
    private static final IMetadataSectionCTM.Serializer SERIALIZER = new IMetadataSectionCTM.Serializer();

    public static Resource getResource(TextureAtlasSprite sprite) throws IOException {
        return ResourceUtil.getResource(ResourceUtil.spriteToAbsolute(sprite.m_118413_()));
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.m_135815_().startsWith("textures/")) {
            sprite = new ResourceLocation(sprite.m_135827_(), "textures/" + sprite.m_135815_());
        }
        if (!sprite.m_135815_().endsWith(".png")) {
            sprite = new ResourceLocation(sprite.m_135827_(), sprite.m_135815_() + ".png");
        }
        return sprite;
    }

    public static Resource getResource(ResourceLocation res) throws IOException {
        return Minecraft.m_91087_().m_91098_().m_142591_(res);
    }

    public static Resource getResourceUnsafe(ResourceLocation res) {
        try {
            return ResourceUtil.getResource(res);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static IMetadataSectionCTM getMetadata(ResourceLocation res) throws IOException {
        IMetadataSectionCTM ret;
        if (metadataCache.containsKey(res)) {
            return metadataCache.get(res);
        }
        try (Resource resource = ResourceUtil.getResource(res);){
            ret = (IMetadataSectionCTM)resource.m_5507_((MetadataSectionSerializer)SERIALIZER);
        }
        catch (FileNotFoundException e) {
            ret = null;
        }
        catch (JsonParseException e) {
            throw new IOException("Error loading metadata for location " + res, e);
        }
        metadataCache.put(res, ret);
        return ret;
    }

    @Nullable
    public static IMetadataSectionCTM getMetadata(TextureAtlasSprite sprite) throws IOException {
        return ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(sprite.m_118413_()));
    }

    @Nullable
    public static IMetadataSectionCTM getMetadataUnsafe(TextureAtlasSprite sprite) {
        try {
            return ResourceUtil.getMetadata(sprite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invalidateCaches() {
        metadataCache.clear();
    }

    private ResourceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

